# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/)
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

Generated by [`auto-changelog`](https://github.com/CookPete/auto-changelog).

## [v3.2.22](https://github.com/leandrowd/react-responsive-carousel/compare/v3.2.21...v3.2.22) - 2021-10-21

### Merged

-   Prevent anchor tags from being accessed when swiping [`#645`](https://github.com/leandrowd/react-responsive-carousel/pull/645)
-   build(deps): bump tmpl from 1.0.4 to 1.0.5 [`#651`](https://github.com/leandrowd/react-responsive-carousel/pull/651)

### Commits

-   build(deps): bump tmpl from 1.0.4 to 1.0.5 [`95b9e36`](https://github.com/leandrowd/react-responsive-carousel/commit/95b9e3607d2ba10932a783899d62792ce49e2d4b)

## [v3.2.21](https://github.com/leandrowd/react-responsive-carousel/compare/v3.2.20...v3.2.21) - 2021-08-18

### Merged

-   Bugfix/thumb swipe move with percent [`#541`](https://github.com/leandrowd/react-responsive-carousel/pull/541)
-   feat: add `ariaLabel` to the props, fixes #611 [`#612`](https://github.com/leandrowd/react-responsive-carousel/pull/612)
-   fix: carousel autoplaying after swipe [`#624`](https://github.com/leandrowd/react-responsive-carousel/pull/624)
-   Update README.md [`#625`](https://github.com/leandrowd/react-responsive-carousel/pull/625)
-   build(deps): bump path-parse from 1.0.6 to 1.0.7 [`#635`](https://github.com/leandrowd/react-responsive-carousel/pull/635)

### Fixed

-   Merge pull request #612 from francoismassart/issue/gh-611-aria-label [`#611`](https://github.com/leandrowd/react-responsive-carousel/issues/611)

### Commits

-   update tests [`915abe6`](https://github.com/leandrowd/react-responsive-carousel/commit/915abe6189e7d33152f1f83927c4d39588cda54c)

## [v3.2.20](https://github.com/leandrowd/react-responsive-carousel/compare/v3.2.19...v3.2.20) - 2021-07-19

### Merged

-   export Carousel Props [`#623`](https://github.com/leandrowd/react-responsive-carousel/pull/623)

### Commits

-   Update issue templates [`b0d1eae`](https://github.com/leandrowd/react-responsive-carousel/commit/b0d1eae01c2e06af80781be419562a6562e0c056)

## [v3.2.19](https://github.com/leandrowd/react-responsive-carousel/compare/v3.2.18...v3.2.19) - 2021-07-02

### Merged

-   leandrowdgh-545: Remove tabindex for non-interactive div [`#586`](https://github.com/leandrowd/react-responsive-carousel/pull/586)
-   #596 - fix autoplay after mobile swipe [`#597`](https://github.com/leandrowd/react-responsive-carousel/pull/597)
-   Added ability to use mouse on the thumbnails [`#607`](https://github.com/leandrowd/react-responsive-carousel/pull/607)
-   build(deps): bump handlebars from 4.7.6 to 4.7.7 [`#598`](https://github.com/leandrowd/react-responsive-carousel/pull/598)
-   build(deps): bump lodash from 4.17.20 to 4.17.21 [`#599`](https://github.com/leandrowd/react-responsive-carousel/pull/599)
-   build(deps): bump ua-parser-js from 0.7.22 to 0.7.28 [`#600`](https://github.com/leandrowd/react-responsive-carousel/pull/600)
-   build(deps): bump hosted-git-info from 2.8.8 to 2.8.9 [`#601`](https://github.com/leandrowd/react-responsive-carousel/pull/601)

### Fixed

-   feat: add `ariaLabel` to the props, fixes #611 [`#611`](https://github.com/leandrowd/react-responsive-carousel/issues/611)

### Commits

-   leandrowdgh-545: Remove tabindex for non-interactive div [`e1ba29b`](https://github.com/leandrowd/react-responsive-carousel/commit/e1ba29b5b80cb0c9305dd0355c4d56b76cd40e65)

## [v3.2.18](https://github.com/leandrowd/react-responsive-carousel/compare/v3.2.17...v3.2.18) - 2021-04-01

### Merged

-   #562: Fix carousel autoplaying after swipe [`#583`](https://github.com/leandrowd/react-responsive-carousel/pull/583)

### Commits

-   3.2.18 [`5e33b5b`](https://github.com/leandrowd/react-responsive-carousel/commit/5e33b5b6b8a3d45d70827d229deeb50f0c9f3bcb)

## [v3.2.17](https://github.com/leandrowd/react-responsive-carousel/compare/v3.2.16...v3.2.17) - 2021-04-01

### Merged

-   build(deps): bump y18n from 4.0.0 to 4.0.1 [`#584`](https://github.com/leandrowd/react-responsive-carousel/pull/584)

### Commits

-   #562: Fix autoplay on swipe [`c81a9ec`](https://github.com/leandrowd/react-responsive-carousel/commit/c81a9ec202f59642696f4b87d319b35dfe256fc7)

## [v3.2.16](https://github.com/leandrowd/react-responsive-carousel/compare/v3.2.15...v3.2.16) - 2021-03-26

### Merged

-   Fix prettier on windows [`#580`](https://github.com/leandrowd/react-responsive-carousel/pull/580)

### Commits

-   3.2.16 [`56243cc`](https://github.com/leandrowd/react-responsive-carousel/commit/56243cc66b54d3bf0a3a31743ad1b4b8f8acf64c)

## [v3.2.15](https://github.com/leandrowd/react-responsive-carousel/compare/v3.2.14...v3.2.15) - 2021-03-18

### Merged

-   #525: Fix indicator click not resetting autoplay [`#561`](https://github.com/leandrowd/react-responsive-carousel/pull/561)

### Commits

-   Change methods to use moveTo to change slides [`acfaa1c`](https://github.com/leandrowd/react-responsive-carousel/commit/acfaa1c12dbbe879320afd5936c8a68c009feb59)

## [v3.2.14](https://github.com/leandrowd/react-responsive-carousel/compare/v3.2.13...v3.2.14) - 2021-03-15

### Merged

-   styles: Remove slide default black background [`#522`](https://github.com/leandrowd/react-responsive-carousel/pull/522)
-   Add props documentation to README [`#564`](https://github.com/leandrowd/react-responsive-carousel/pull/564)
-   build(deps): bump elliptic from 6.5.3 to 6.5.4 [`#574`](https://github.com/leandrowd/react-responsive-carousel/pull/574)

### Commits

-   build(deps): bump elliptic from 6.5.3 to 6.5.4 [`f97d9e0`](https://github.com/leandrowd/react-responsive-carousel/commit/f97d9e0d37fdc912f0f298ba9d5c5a5ad8cc3dd2)

## [v3.2.13](https://github.com/leandrowd/react-responsive-carousel/compare/v3.2.12...v3.2.13) - 2021-03-03

### Merged

-   #255 - fade story [`#571`](https://github.com/leandrowd/react-responsive-carousel/pull/571)

### Commits

-   #255: setup testing for animation handlers [`7d7fbcd`](https://github.com/leandrowd/react-responsive-carousel/commit/7d7fbcd43fa0907a65598a6deee276b17d200310)

## [v3.2.12](https://github.com/leandrowd/react-responsive-carousel/compare/v3.2.11...v3.2.12) - 2021-02-12

### Merged

-   Issue/gh 503 autoplay doesnt restart [`#511`](https://github.com/leandrowd/react-responsive-carousel/pull/511)
-   build(deps): bump ini from 1.3.5 to 1.3.7 [`#532`](https://github.com/leandrowd/react-responsive-carousel/pull/532)
-   fix: dynamic height not work with a tag wrapper [`#537`](https://github.com/leandrowd/react-responsive-carousel/pull/537)
-   #534: Fix Carousel swipeable with one child [`#544`](https://github.com/leandrowd/react-responsive-carousel/pull/544)
-   #546: Adding visual style to focused buttons [`#549`](https://github.com/leandrowd/react-responsive-carousel/pull/549)
-   #553: Resolve type error due to wrong default prop of Carousel component [`#554`](https://github.com/leandrowd/react-responsive-carousel/pull/554)
-   #517: Fix emulated touch never changing slide [`#556`](https://github.com/leandrowd/react-responsive-carousel/pull/556)
-   358 fix glitch when swiping one way then the other [`#509`](https://github.com/leandrowd/react-responsive-carousel/pull/509)
-   #547: Moving carousel controls for kbd users [`#551`](https://github.com/leandrowd/react-responsive-carousel/pull/551)

### Commits

-   #547: Moving carousel controls for kbd users [`4b8fbcf`](https://github.com/leandrowd/react-responsive-carousel/commit/4b8fbcf928dfd7489ce6d98da5fe3b34f8f09f3f)

## [v3.2.11](https://github.com/leandrowd/react-responsive-carousel/compare/v3.2.10...v3.2.11) - 2020-12-05

### Merged

-   #514 Add autoFocus prop so useKeyboardArrows works without clicking first [`#530`](https://github.com/leandrowd/react-responsive-carousel/pull/530)

### Commits

-   #514 Introduce autoFocus props so useKeyboardArrows can work without initial interaction [`1b06898`](https://github.com/leandrowd/react-responsive-carousel/commit/1b06898ad223a8e29cc4e0d4f911b6e553e9946c)

## [v3.2.10](https://github.com/leandrowd/react-responsive-carousel/compare/v3.2.9...v3.2.10) - 2020-09-23

### Merged

-   build(deps): bump elliptic from 6.4.0 to 6.5.3 [`#483`](https://github.com/leandrowd/react-responsive-carousel/pull/483)
-   fix: getInitialImage returns the first image of the selected item [`#475`](https://github.com/leandrowd/react-responsive-carousel/pull/475)
-   #210: fix dynamiHeight for other elements than img [`#492`](https://github.com/leandrowd/react-responsive-carousel/pull/492)
-   fix: #501 [`#502`](https://github.com/leandrowd/react-responsive-carousel/pull/502)
-   build(deps): bump handlebars from 4.0.12 to 4.7.6 [`#497`](https://github.com/leandrowd/react-responsive-carousel/pull/497)
-   gh358 Add prop to control swipe scroll behavior [`#507`](https://github.com/leandrowd/react-responsive-carousel/pull/507)

### Commits

-   Update lock file [`c0f8ebf`](https://github.com/leandrowd/react-responsive-carousel/commit/c0f8ebfc447c1e0806064e8ce6b84e882cb4728a)

## [v3.2.9](https://github.com/leandrowd/react-responsive-carousel/compare/v3.2.8...v3.2.9) - 2020-06-27

### Merged

-   fix: resolve building issues on Windows [`#461`](https://github.com/leandrowd/react-responsive-carousel/pull/461)
-   Fix swipeScrollTolerance when infiniteLoop [`#465`](https://github.com/leandrowd/react-responsive-carousel/pull/465)
-   fix: link to storybook code in README [`#466`](https://github.com/leandrowd/react-responsive-carousel/pull/466)

### Commits

-   Using node 10 locally [`d0ec31b`](https://github.com/leandrowd/react-responsive-carousel/commit/d0ec31b373e0f056f4d7160df9d545f24788b4c9)

## [v3.2.8](https://github.com/leandrowd/react-responsive-carousel/compare/v3.2.7...v3.2.8) - 2020-06-16

### Merged

-   fix thumbs moveTo [`#456`](https://github.com/leandrowd/react-responsive-carousel/pull/456)
-   #444 and #301: sets padding explicitly in .control-dots [`#458`](https://github.com/leandrowd/react-responsive-carousel/pull/458)
-   build(deps): bump websocket-extensions from 0.1.1 to 0.1.4 [`#453`](https://github.com/leandrowd/react-responsive-carousel/pull/453)

### Commits

-   build(deps): bump websocket-extensions from 0.1.1 to 0.1.4 [`31f6f12`](https://github.com/leandrowd/react-responsive-carousel/commit/31f6f12bff915ff918daa4e1a9371ed6e2f662c0)

## [v3.2.7](https://github.com/leandrowd/react-responsive-carousel/compare/v3.2.6...v3.2.7) - 2020-05-06

### Merged

-   gh-440: Remove env vars to allow building on windows without issues [`#443`](https://github.com/leandrowd/react-responsive-carousel/pull/443)

### Commits

-   gh-440: Remove env vars to allow building on windows without issues [`a071604`](https://github.com/leandrowd/react-responsive-carousel/commit/a07160491dda7f95c62cb4c485e4d6b83b64d687)

## [v3.2.6](https://github.com/leandrowd/react-responsive-carousel/compare/v3.2.5...v3.2.6) - 2020-05-06

### Merged

-   gh-439: Allow IE11 compilation and more [`#442`](https://github.com/leandrowd/react-responsive-carousel/pull/442)

### Commits

-   Fix storybook storysource [`0780a0a`](https://github.com/leandrowd/react-responsive-carousel/commit/0780a0aeacd3be585bd7a494b497918406e92c30)

## [v3.2.5](https://github.com/leandrowd/react-responsive-carousel/compare/v3.2.4...v3.2.5) - 2020-04-26

### Merged

-   Gh-429: Converting codebase to typescript [`#435`](https://github.com/leandrowd/react-responsive-carousel/pull/435)

### Commits

-   gh-429: Moving remaining files and fixing tests [`59c7d1b`](https://github.com/leandrowd/react-responsive-carousel/commit/59c7d1bb4ff1a5d8c86c1444d43b2263edf6486d)

## [v3.2.4](https://github.com/leandrowd/react-responsive-carousel/compare/v3.2.3...v3.2.4) - 2020-04-13

### Merged

-   gh-430: Ensure component can be rendered in SSR [`#431`](https://github.com/leandrowd/react-responsive-carousel/pull/431)

### Commits

-   gh-430: Ensure component can be rendered in SSR [`0beb7c5`](https://github.com/leandrowd/react-responsive-carousel/commit/0beb7c54a49852a747c40e4e55e281abbab1bbfb)

## [v3.2.3](https://github.com/leandrowd/react-responsive-carousel/compare/v3.2.1...v3.2.3) - 2020-04-12

### Merged

-   Gh 427: Get rid of gulp [`#428`](https://github.com/leandrowd/react-responsive-carousel/pull/428)

### Commits

-   gh-427: Remove and git ignore lib folder [`2973bd5`](https://github.com/leandrowd/react-responsive-carousel/commit/2973bd586cb9f9f043f91f76123a5e7d954129d1)

## [v3.2.1](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.58-next.1...v3.2.1) - 2020-04-12

### Merged

-   Gh 422 modernize repo [`#423`](https://github.com/leandrowd/react-responsive-carousel/pull/423)

### Commits

-   3.2.1 [`e2adf31`](https://github.com/leandrowd/react-responsive-carousel/commit/e2adf31764a5c15496e1229507b8e56295b21f0e)

## [v3.1.58-next.1](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.58-next.0...v3.1.58-next.1) - 2020-04-12

### Commits

-   gh-422: Include codesandbox in the repo to allow auto update [`15c24dc`](https://github.com/leandrowd/react-responsive-carousel/commit/15c24dca3b6bc2076b0398533ab0c52aa49ccb60)
-   3.1.58-next.1 [`d6d9624`](https://github.com/leandrowd/react-responsive-carousel/commit/d6d9624123bad271bfe2359134ed98378a9e5407)

## [v3.1.58-next.0](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.57...v3.1.58-next.0) - 2020-04-12

### Commits

-   gh-422: Upgrade storybook and reorganize stories [`3e712c1`](https://github.com/leandrowd/react-responsive-carousel/commit/3e712c195fb87a9b0fb74402827bd10e1539f6d2)
-   gh-422: Publish cjs and es modules to npm [`b67f32b`](https://github.com/leandrowd/react-responsive-carousel/commit/b67f32b0ca81cb2a5f3bcb2a4bf8c25cd58825b3)
-   gh-422: Update react + babel and get tests to pass [`56eaefc`](https://github.com/leandrowd/react-responsive-carousel/commit/56eaefcaaaecbbd00d1c42ca8df9f1df8e515270)

## [v3.1.57](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.56...v3.1.57) - 2020-04-07

### Merged

-   gh-206: Better video controls [`#417`](https://github.com/leandrowd/react-responsive-carousel/pull/417)

### Commits

-   gh-206: Allow intercepting item and thumbs before rendering so it's easier to control videos [`cb052b5`](https://github.com/leandrowd/react-responsive-carousel/commit/cb052b519fffd26a3754a5093cc8f1f0b0bde02f)

## [v3.1.56](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.55...v3.1.56) - 2020-04-05

### Merged

-   gh-414: disable outline of carousel [`#415`](https://github.com/leandrowd/react-responsive-carousel/pull/415)

### Commits

-   gh-414: disable outline of carousel [`000edfe`](https://github.com/leandrowd/react-responsive-carousel/commit/000edfe2e1221a6029f66efa7641d7a8b42a0777)

## [v3.1.55](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.54...v3.1.55) - 2020-04-05

### Merged

-   #232: Add support for custom arrows and custom indicators [`#413`](https://github.com/leandrowd/react-responsive-carousel/pull/413)

### Commits

-   gh-232: Add support for custom indicators through render props [`42597bf`](https://github.com/leandrowd/react-responsive-carousel/commit/42597bfc8fee90fb2342fc08df4ae9ffc0a27295)

## [v3.1.54](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.53...v3.1.54) - 2020-04-05

### Commits

-   3.1.54 [`a165fa6`](https://github.com/leandrowd/react-responsive-carousel/commit/a165fa6e4207fe26205dee9329f06e89f0aaa8ea)

## [v3.1.53](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.52...v3.1.53) - 2020-04-05

### Merged

-   gh-407: only allow keyboard navigation if focus is within carousel [`#412`](https://github.com/leandrowd/react-responsive-carousel/pull/412)
-   Fix issue #335 - no images inside carousel [`#411`](https://github.com/leandrowd/react-responsive-carousel/pull/411)

### Commits

-   gh-407: only allow keyboard navigation if focus is within carousel [`56b2af5`](https://github.com/leandrowd/react-responsive-carousel/commit/56b2af56a5bd3e242dcd50b6f86ac2f6bce1bc12)

## [v3.1.52](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.51...v3.1.52) - 2020-04-05

### Merged

-   remove componentWillReceiveProps [`#394`](https://github.com/leandrowd/react-responsive-carousel/pull/394)
-   Fix thumbnails not swiping on mobile [`#408`](https://github.com/leandrowd/react-responsive-carousel/pull/408)
-   Setup prettier to avoid whitespacing and formatting issues on PRs [`#373`](https://github.com/leandrowd/react-responsive-carousel/pull/373)

### Commits

-   Install prettier to avoid different formatting in contributions [`4410775`](https://github.com/leandrowd/react-responsive-carousel/commit/44107757061bb962f92085f3086c525062262075)

## [v3.1.51](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.50...v3.1.51) - 2019-10-23

### Merged

-   Add callback on swipe events [`#366`](https://github.com/leandrowd/react-responsive-carousel/pull/366)
-   Fix remaining LGTM Warnings [`#291`](https://github.com/leandrowd/react-responsive-carousel/pull/291)
-   Update README.md [`#361`](https://github.com/leandrowd/react-responsive-carousel/pull/361)
-   Issue 266 [`#352`](https://github.com/leandrowd/react-responsive-carousel/pull/352)

### Commits

-   Refactor labels to obj prop. Aria label all buttons. [`c5320e6`](https://github.com/leandrowd/react-responsive-carousel/commit/c5320e6317e3f6996f820ecfed12ea83e09cc25f)

## [v3.1.50](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.49...v3.1.50) - 2019-08-11

### Merged

-   Issue #345 fix(onClickItem): cancelClick should be true when onSwipeEnd [`#346`](https://github.com/leandrowd/react-responsive-carousel/pull/346)

### Commits

-   issue-266: [`e932d21`](https://github.com/leandrowd/react-responsive-carousel/commit/e932d2181d009f02baf31f67bcdd5ce5e2811f07)

## [v3.1.49](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.47...v3.1.49) - 2019-04-17

### Merged

-   update watchify [`#330`](https://github.com/leandrowd/react-responsive-carousel/pull/330)
-   Issue #256: onItemClick doesn't work when you only have 1 item [`#329`](https://github.com/leandrowd/react-responsive-carousel/pull/329)
-   Added swipeable in CarouselProps for Typescript, fixes #264 [`#319`](https://github.com/leandrowd/react-responsive-carousel/pull/319)

### Fixed

-   Merge pull request #319 from jinster/issue-264 [`#264`](https://github.com/leandrowd/react-responsive-carousel/issues/264)
-   Added swipeable in CarouselProps for Typescript, fixes #264 [`#264`](https://github.com/leandrowd/react-responsive-carousel/issues/264)

### Commits

-   update watchify [`6bb5064`](https://github.com/leandrowd/react-responsive-carousel/commit/6bb50640426d892f9099979dfb84c19d48741cd4)

## [v3.1.47](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.46...v3.1.47) - 2019-02-11

### Merged

-   issue#309: Fix swipe direction [`#313`](https://github.com/leandrowd/react-responsive-carousel/pull/313)

### Commits

-   issue#309: Fix tests for swipe direction [`04fb23b`](https://github.com/leandrowd/react-responsive-carousel/commit/04fb23b8d1d6ad9ae8bff02d51cfa364ae8366e0)

## [v3.1.46](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.45...v3.1.46) - 2019-01-23

### Merged

-   #303: Fixing autoplay when swipeable is turned off [`#307`](https://github.com/leandrowd/react-responsive-carousel/pull/307)
-   Fix remaining LGTM recommendations [`#292`](https://github.com/leandrowd/react-responsive-carousel/pull/292)
-   Classify /lib as generated code for LGTM [`#293`](https://github.com/leandrowd/react-responsive-carousel/pull/293)
-   Fix default interval value to match what is in actual code. [`#290`](https://github.com/leandrowd/react-responsive-carousel/pull/290)

### Commits

-   issue #303: Fixing autoplay when swipeable is turned off [`1b3712e`](https://github.com/leandrowd/react-responsive-carousel/commit/1b3712e39b35d17f1d4f96fa0a5801db53771bb7)

## [v3.1.45](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.44...v3.1.45) - 2018-12-15

### Commits

-   3.1.45 [`b9eb535`](https://github.com/leandrowd/react-responsive-carousel/commit/b9eb53519abf7f9c4a1ffd0cbb0c5a684dc7fadd)

## [v3.1.44](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.43...v3.1.44) - 2018-12-14

### Merged

-   add infinite scrolling from end to start [`#267`](https://github.com/leandrowd/react-responsive-carousel/pull/267)
-   accessibility: allow thumbnails to be navigable via keyboard [`#273`](https://github.com/leandrowd/react-responsive-carousel/pull/273)
-   accessibility: allow dots to be accessible via keyboard [`#274`](https://github.com/leandrowd/react-responsive-carousel/pull/274)
-   [chore] Fix a number of alerts found on LGTM.com [`#287`](https://github.com/leandrowd/react-responsive-carousel/pull/287)
-   Handle undefined item list ref [`#288`](https://github.com/leandrowd/react-responsive-carousel/pull/288)

### Commits

-   accessibility: allow dots to be accessible via keyboard [`b061c2e`](https://github.com/leandrowd/react-responsive-carousel/commit/b061c2eede8eab8c46b0da1df5de60a2aa5a0908)

## [v3.1.43](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.42...v3.1.43) - 2018-10-05

### Merged

-   Issue #261 - style control arrow buttons using CSS classes instead of… [`#271`](https://github.com/leandrowd/react-responsive-carousel/pull/271)

### Commits

-   add infinite scrolling from end to start [`b45e57b`](https://github.com/leandrowd/react-responsive-carousel/commit/b45e57b906fd6fc338d4da10bc8b776d7888b6ca)

## [v3.1.42](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.41...v3.1.42) - 2018-09-17

### Merged

-   css file added in usage (README.md) [`#260`](https://github.com/leandrowd/react-responsive-carousel/pull/260)
-   Restore resetPosition but place on componentDidUpdate [`#263`](https://github.com/leandrowd/react-responsive-carousel/pull/263)

### Commits

-   Restore resetPosition but place on componentDidUpdate so it resets position to the NEW slide in the case where a change just occurred [`821ed17`](https://github.com/leandrowd/react-responsive-carousel/commit/821ed175c154d29e3e493dac25283683fc2107b4)

## [v3.1.41](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.40...v3.1.41) - 2018-06-20

### Merged

-   fix: remove resetPosition() [`#249`](https://github.com/leandrowd/react-responsive-carousel/pull/249)

### Commits

-   Removing package-lock.json [`cfc2238`](https://github.com/leandrowd/react-responsive-carousel/commit/cfc2238400157be54911e83debe096ff709c956d)

## [v3.1.40](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.39...v3.1.40) - 2018-06-16

### Merged

-   Update autoPlay when props received [`#253`](https://github.com/leandrowd/react-responsive-carousel/pull/253)

### Commits

-   add built files [`c320208`](https://github.com/leandrowd/react-responsive-carousel/commit/c32020842a2809ede7a1f91400ee8206097fe76a)

## [v3.1.39](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.38...v3.1.39) - 2018-05-22

### Merged

-   Fix itemsList ref [`#248`](https://github.com/leandrowd/react-responsive-carousel/pull/248)

### Commits

-   Fix typeof comparison [`4ec3232`](https://github.com/leandrowd/react-responsive-carousel/commit/4ec32325f0ca15916c5af8028228c5f5b0a60209)

## [v3.1.38](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.37...v3.1.38) - 2018-05-21

### Merged

-   Fix wrapperSize ref [`#247`](https://github.com/leandrowd/react-responsive-carousel/pull/247)

### Commits

-   Fix wrapperSize init [`95eef5b`](https://github.com/leandrowd/react-responsive-carousel/commit/95eef5b80f2e02de0e3afbeeeb76cb2c4dd07658)

## [v3.1.37](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.35...v3.1.37) - 2018-04-24

### Merged

-   Fix dynamicHeight initialization [`#240`](https://github.com/leandrowd/react-responsive-carousel/pull/240)
-   make carousel work with only 1 child passed in [`#222`](https://github.com/leandrowd/react-responsive-carousel/pull/222)
-   [#233] Use refs callback [`#234`](https://github.com/leandrowd/react-responsive-carousel/pull/234)

### Commits

-   Updated to refs callback [`7707995`](https://github.com/leandrowd/react-responsive-carousel/commit/77079959008c240710841c1934d794e19b9702f2)

## [v3.1.35](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.34...v3.1.35) - 2018-03-31

### Merged

-   Remove thumb flickering, update images on change, and other fixes [`#229`](https://github.com/leandrowd/react-responsive-carousel/pull/229)

### Commits

-   3.1.35 [`fd00f7e`](https://github.com/leandrowd/react-responsive-carousel/commit/fd00f7eab32095c9c18b97d70e6349f4ab7a98d9)

## [v3.1.34](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.33...v3.1.34) - 2018-03-29

### Merged

-   Add property swipeable to enable and disable swiping [`#188`](https://github.com/leandrowd/react-responsive-carousel/pull/188)

### Commits

-   remove .idea/ directory; remove package-lock.json [`149d4a1`](https://github.com/leandrowd/react-responsive-carousel/commit/149d4a1910eb72afd42bd9e9b7cfa11fa08ad58c)

## [v3.1.33](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.32...v3.1.33) - 2018-01-29

### Merged

-   Prevent affecting styling inside slide [`#212`](https://github.com/leandrowd/react-responsive-carousel/pull/212)

### Commits

-   Updating example with external controls [`411cd50`](https://github.com/leandrowd/react-responsive-carousel/commit/411cd5044a56cae870bafd8a42d602e6cce1539c)

## [v3.1.32](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.31...v3.1.32) - 2018-01-29

### Commits

-   3.1.32 [`9c1b84d`](https://github.com/leandrowd/react-responsive-carousel/commit/9c1b84da28f1566bbc29988a5b41554dfff7232e)

## [v3.1.31](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.30...v3.1.31) - 2018-01-29

### Merged

-   Add `centerMode` and `centerSlidePercentage` to index.d.ts [`#208`](https://github.com/leandrowd/react-responsive-carousel/pull/208)

### Commits

-   chore: add build /lib [`39184c9`](https://github.com/leandrowd/react-responsive-carousel/commit/39184c93a1e431f904ba18887e137a4ea815733d)

## [v3.1.30](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.29...v3.1.30) - 2017-12-01

### Merged

-   BUGFIX - updates to arrow key navigation handler to work in IE/Edge. … [`#201`](https://github.com/leandrowd/react-responsive-carousel/pull/201)

### Commits

-   BUGFIX - updates to arrow key navigation handler to work in IE/Edge. Changed match from e.key =&gt; e.keyCode. Updated Carousel tests to account for new methods. There are two tests that fail, but they were failing in the existing repo as well. [`d538ad3`](https://github.com/leandrowd/react-responsive-carousel/commit/d538ad38c7f41391bdaa1dab889e1e9680a911a7)

## [v3.1.29](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.28...v3.1.29) - 2017-11-30

### Merged

-   feat: add verticalSwipe property to deal with mobile vertical swipping. [`#199`](https://github.com/leandrowd/react-responsive-carousel/pull/199)
-   issue #191: Add alternative to codepen [`#192`](https://github.com/leandrowd/react-responsive-carousel/pull/192)

### Commits

-   refactor: using ref as a callback instead of string to fix react ref error [`8a276f9`](https://github.com/leandrowd/react-responsive-carousel/commit/8a276f9eaa665d72f0290be32036ebde95663201)

## [v3.1.28](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.27...v3.1.28) - 2017-10-20

### Merged

-   Add centerMode [`#185`](https://github.com/leandrowd/react-responsive-carousel/pull/185)
-   Create CODE_OF_CONDUCT.md [`#181`](https://github.com/leandrowd/react-responsive-carousel/pull/181)
-   Add license scan report and status [`#180`](https://github.com/leandrowd/react-responsive-carousel/pull/180)

### Commits

-   Add centerMode prop [`9a20609`](https://github.com/leandrowd/react-responsive-carousel/commit/9a20609c8c0bf8582ee28a4131c4db6afc2ded28)

## [v3.1.27](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.26...v3.1.27) - 2017-09-26

### Merged

-   #151: Autoplay keeps trying to transition after the component has bee… [`#179`](https://github.com/leandrowd/react-responsive-carousel/pull/179)

### Commits

-   3.1.27 [`8e4b3ae`](https://github.com/leandrowd/react-responsive-carousel/commit/8e4b3ae6bf9865e0dcfd7246851789a26c21dfc6)

## [v3.1.26](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.25...v3.1.26) - 2017-09-22

### Merged

-   add thumbWidth prop to allow specifying thumbnail width [`#177`](https://github.com/leandrowd/react-responsive-carousel/pull/177)
-   Very minor change in readme [`#173`](https://github.com/leandrowd/react-responsive-carousel/pull/173)

### Commits

-   Adding CONTRIBUTING.md [`e9e1cc1`](https://github.com/leandrowd/react-responsive-carousel/commit/e9e1cc123feccb09aa737829109cda6058ba2413)

## [v3.1.25](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.24...v3.1.25) - 2017-08-26

### Merged

-   Issue 159 [`#161`](https://github.com/leandrowd/react-responsive-carousel/pull/161)
-   Update index.d.ts [`#158`](https://github.com/leandrowd/react-responsive-carousel/pull/158)

### Commits

-   issue-159: Ignoring storybook when publishing to npm [`c852ece`](https://github.com/leandrowd/react-responsive-carousel/commit/c852ece695f306a946514abcd223c9b7959f3c43)

## [v3.1.24](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.23...v3.1.24) - 2017-07-04

### Merged

-   #148 Autoplay and stop on hover causes a warning. [`#149`](https://github.com/leandrowd/react-responsive-carousel/pull/149)

### Commits

-   #148 Autoplay and stop on hover causes a warning. [`ccf032d`](https://github.com/leandrowd/react-responsive-carousel/commit/ccf032de466a5a13dc6d4b9347c03daf1644df1c)

## [v3.1.23](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.22...v3.1.23) - 2017-07-04

### Merged

-   Types author header. [`#147`](https://github.com/leandrowd/react-responsive-carousel/pull/147)
-   Fork updated. [`#1`](https://github.com/leandrowd/react-responsive-carousel/pull/1)

### Commits

-   #148 Autoplay and stop on hover causes a warning. [`c3a147e`](https://github.com/leandrowd/react-responsive-carousel/commit/c3a147e5f61ef38adcdf056fc0f896e3169a162e)

## [v3.1.22](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.21...v3.1.22) - 2017-07-03

### Merged

-   TypeScript types definitions file added. [`#145`](https://github.com/leandrowd/react-responsive-carousel/pull/145)

### Commits

-   TypeScript types definitions file added. [`8e5441a`](https://github.com/leandrowd/react-responsive-carousel/commit/8e5441aba8bdb940bec4c9c9bbec96af288889e5)

## [v3.1.21](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.20...v3.1.21) - 2017-06-25

### Merged

-   #134: Example of using external controls [`#144`](https://github.com/leandrowd/react-responsive-carousel/pull/144)

### Commits

-   #134: Using move to on componentWillReceiveProps so the carousel respects its boundaries when changed through external controls [`eaba563`](https://github.com/leandrowd/react-responsive-carousel/commit/eaba5630e1304ce4965c15aaca9831afddd7d7c7)

## [v3.1.20](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.19...v3.1.20) - 2017-06-24

### Merged

-   #140: Revert to initial position when movement is less than tolerance [`#143`](https://github.com/leandrowd/react-responsive-carousel/pull/143)
-   Update README.md [`#135`](https://github.com/leandrowd/react-responsive-carousel/pull/135)

### Commits

-   #140: Revert to initial position when movement is less than tolerance [`2fa8a61`](https://github.com/leandrowd/react-responsive-carousel/commit/2fa8a61ec934dbe35ba489ac828f27c7e3385de2)

## [v3.1.19](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.18...v3.1.19) - 2017-05-29

### Merged

-   Issue 131 - Allow custom formatting of the status [`#132`](https://github.com/leandrowd/react-responsive-carousel/pull/132)

### Commits

-   #131: Removing old unused files [`1d4a623`](https://github.com/leandrowd/react-responsive-carousel/commit/1d4a623d90427a6f6523bfe04d241e57bd9cc2e2)

## [v3.1.18](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.17...v3.1.18) - 2017-05-29

### Merged

-   #129: Allow only right and left keys when axis is horizontal [`#130`](https://github.com/leandrowd/react-responsive-carousel/pull/130)

### Commits

-   #129: Allow only right and left keys when axis is horizontal [`52a922c`](https://github.com/leandrowd/react-responsive-carousel/commit/52a922c5a1de25337f36406b3649df04436d8303)

## [v3.1.17](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.16...v3.1.17) - 2017-05-22

### Merged

-   #118: Fixing jank swipe on mobile [`#125`](https://github.com/leandrowd/react-responsive-carousel/pull/125)

### Commits

-   #118: Fixing jank swipe on mobile [`42aede5`](https://github.com/leandrowd/react-responsive-carousel/commit/42aede54eafe53974f7b40dbf369dde50128e310)

## [v3.1.16](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.15...v3.1.16) - 2017-05-11

### Merged

-   #118: Adding support to swipe tolerance [`#121`](https://github.com/leandrowd/react-responsive-carousel/pull/121)

### Commits

-   #118: Adding support to swipe tolerance [`a3aaa12`](https://github.com/leandrowd/react-responsive-carousel/commit/a3aaa12bfb731ee428288728fbaaaaa60f69cb3e)

## [v3.1.15](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.14...v3.1.15) - 2017-04-30

### Merged

-   #97: Fixing warning about passive listeners and preventDefault [`#117`](https://github.com/leandrowd/react-responsive-carousel/pull/117)

### Commits

-   #97: Fixing issue with auto play and swipe on mobile [`c7ac56c`](https://github.com/leandrowd/react-responsive-carousel/commit/c7ac56ca2e74db81225535d610c46ce684a340cf)

## [v3.1.14](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.13...v3.1.14) - 2017-04-29

### Merged

-   #112: Fix emulateTouch [`#116`](https://github.com/leandrowd/react-responsive-carousel/pull/116)

### Commits

-   #112: Fix emulateTouch [`5d5b712`](https://github.com/leandrowd/react-responsive-carousel/commit/5d5b7122c6c6500c584d1370433bd15b46b67038)

## [v3.1.13](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.12...v3.1.13) - 2017-04-29

### Merged

-   #112: Fix auto play [`#115`](https://github.com/leandrowd/react-responsive-carousel/pull/115)

### Commits

-   #112: Fix auto play [`f74e1a8`](https://github.com/leandrowd/react-responsive-carousel/commit/f74e1a8c1001442b1237fd5fc0f4e730029aa340)

## [v3.1.12](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.11...v3.1.12) - 2017-04-29

### Merged

-   #98: Fixing bug where the Thumbs component would throw an error if a custom component was rendered inside it [`#114`](https://github.com/leandrowd/react-responsive-carousel/pull/114)
-   #112: Converting source to es6 (MVP) [`#113`](https://github.com/leandrowd/react-responsive-carousel/pull/113)

### Commits

-   #112: Converting source to es6 [`8f0588d`](https://github.com/leandrowd/react-responsive-carousel/commit/8f0588d873118f500ad40b8bcefb955ae242fa89)

## [v3.1.11](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.10...v3.1.11) - 2017-04-26

### Merged

-   Solving SSR problem when children is lazy loaded. [`#111`](https://github.com/leandrowd/react-responsive-carousel/pull/111)

### Commits

-   #98: Adding snapshot tests [`0d74a56`](https://github.com/leandrowd/react-responsive-carousel/commit/0d74a56168d4a043f723a8eb1f10c5a353c412bd)

## [v3.1.10](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.9...v3.1.10) - 2017-04-24

### Merged

-   #109: Move create-react-class to dependencies instead of devDependencies [`#110`](https://github.com/leandrowd/react-responsive-carousel/pull/110)

### Commits

-   3.1.10 [`7d8b689`](https://github.com/leandrowd/react-responsive-carousel/commit/7d8b68961d66820e50a0a48d9a696c3c8d71ba41)

## [v3.1.9](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.8...v3.1.9) - 2017-04-24

### Merged

-   #98: Allow carousel slides to be lazy loaded [`#108`](https://github.com/leandrowd/react-responsive-carousel/pull/108)

### Commits

-   #98: Allow carousel slides to be lazy loaded [`aa7df89`](https://github.com/leandrowd/react-responsive-carousel/commit/aa7df89a12efc2e65611f485627bccf1b4f6ae9f)

## [v3.1.8](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.7...v3.1.8) - 2017-04-24

### Merged

-   #101: Updating to react 15.5.4 [`#107`](https://github.com/leandrowd/react-responsive-carousel/pull/107)

### Commits

-   Adding changelog [`76c7822`](https://github.com/leandrowd/react-responsive-carousel/commit/76c782261ffda411a289d1c9a3db8804e0375424)

## [v3.1.7](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.6...v3.1.7) - 2017-04-23

### Merged

-   #104 - Fixes problem where arrows were not appearing after carousel was loaded [`#106`](https://github.com/leandrowd/react-responsive-carousel/pull/106)
-   Fixes issue with initial image having unbinded event [`#103`](https://github.com/leandrowd/react-responsive-carousel/pull/103)

### Fixed

-   Fix #102 [`#102`](https://github.com/leandrowd/react-responsive-carousel/issues/102)

### Commits

-   #104 - Fixes problem where arrows were not appearing after carousel was loaded [`b7b10f3`](https://github.com/leandrowd/react-responsive-carousel/commit/b7b10f328d8dc715e8613c429b9b3a82e9825bc5)

## [v3.1.6](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.5...v3.1.6) - 2017-04-19

### Merged

-   #99: Fixing bug with infinite loop and showArrows=false [`#100`](https://github.com/leandrowd/react-responsive-carousel/pull/100)

### Commits

-   #99: Fixing bug with infinite loop and showArrows=false [`eef9597`](https://github.com/leandrowd/react-responsive-carousel/commit/eef9597936609cb13dab8d29edf798e070980fab)

## [v3.1.5](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.4...v3.1.5) - 2017-03-26

### Merged

-   #63: Stoping autoplay on touch events or manual actions [`#93`](https://github.com/leandrowd/react-responsive-carousel/pull/93)

### Commits

-   #63: Stoping autoplay on touch events or manual actions [`c5c5c0b`](https://github.com/leandrowd/react-responsive-carousel/commit/c5c5c0b6ef77e38222b5219c473181bb22ee4f8f)

## [v3.1.4](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.3...v3.1.4) - 2017-03-26

### Merged

-   #91: Removing check for has3d as all modern browsers support this capability [`#92`](https://github.com/leandrowd/react-responsive-carousel/pull/92)

### Commits

-   #91: Removing check for has3d as all modern browsers support this capability [`105c45b`](https://github.com/leandrowd/react-responsive-carousel/commit/105c45bc1c175c2557adee64f897e3ebea904f50)

## [v3.1.3](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.2...v3.1.3) - 2017-03-11

### Merged

-   #71: Adding custom transition duration [`#89`](https://github.com/leandrowd/react-responsive-carousel/pull/89)

### Commits

-   #71: Adding custom transition duration [`593d846`](https://github.com/leandrowd/react-responsive-carousel/commit/593d8465d0575ea30210a6863f1b87b6356f913c)

## [v3.1.2](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.1...v3.1.2) - 2017-02-26

### Merged

-   #86: Removing unnecessary has3d check [`#88`](https://github.com/leandrowd/react-responsive-carousel/pull/88)

### Commits

-   3.1.2 [`4f32421`](https://github.com/leandrowd/react-responsive-carousel/commit/4f324215642841b8db874dceefcf232a9a3bb180)

## [v3.1.1](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.0...v3.1.1) - 2017-02-26

### Merged

-   #85: Moving event binding to componentDidMount to fix SSR [`#87`](https://github.com/leandrowd/react-responsive-carousel/pull/87)

### Commits

-   #85: Moving event binding to componentDidMount to fix SSR [`1efa37b`](https://github.com/leandrowd/react-responsive-carousel/commit/1efa37be1aa3869b07dd43371739b0aabaca4a03)

## [v3.1.0](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.23...v3.1.0) - 2017-02-10

### Commits

-   3.1.0 [`907486f`](https://github.com/leandrowd/react-responsive-carousel/commit/907486f11fb81313d3eb47269f36a9445c9c5b7e)

## [v3.0.23](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.22...v3.0.23) - 2017-02-10

### Merged

-   #81: Adding support to mouse swipe: [`#82`](https://github.com/leandrowd/react-responsive-carousel/pull/82)

### Commits

-   #81: Adding support to mouse swipe: [`2829f4b`](https://github.com/leandrowd/react-responsive-carousel/commit/2829f4b136fa944ffb8f30474539d77b9a39b8cd)

## [v3.0.22](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.21...v3.0.22) - 2017-01-29

### Merged

-   Fixing issue #69 - styles leaking out of carousel [`#78`](https://github.com/leandrowd/react-responsive-carousel/pull/78)
-   Fixing issue #70 - Adding dynamicHeight prop to adjust when required [`#77`](https://github.com/leandrowd/react-responsive-carousel/pull/77)
-   Fixing issue #72 - changes to autoplay property in runtime wouldn't apply [`#76`](https://github.com/leandrowd/react-responsive-carousel/pull/76)
-   Fixing issue #74 - single images in a slide would cause an error [`#75`](https://github.com/leandrowd/react-responsive-carousel/pull/75)

### Commits

-   Fixing issue #70 - Adding dynamicHeight prop to adjust when required [`77b1eeb`](https://github.com/leandrowd/react-responsive-carousel/commit/77b1eeba376fc976a8fc0721a991fcbaf7eb5711)

## [v3.0.21](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.20...v3.0.21) - 2016-09-26

### Merged

-   Adding support to auto play [`#62`](https://github.com/leandrowd/react-responsive-carousel/pull/62)

### Commits

-   3.0.21 [`414bcfd`](https://github.com/leandrowd/react-responsive-carousel/commit/414bcfdac65323ecd8a56a13a126fb5856dc1c03)

## [v3.0.20](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.19...v3.0.20) - 2016-09-25

### Commits

-   Refactoring tests to use es6 features [`5cc8ac2`](https://github.com/leandrowd/react-responsive-carousel/commit/5cc8ac255e5ff934f7a96041bf07de9ba14a454e)
-   Adding tests for auto play [`0d30188`](https://github.com/leandrowd/react-responsive-carousel/commit/0d30188748600816fb9eaff42b10aa4099041cd4)
-   Adding tolerance for swipe scroll behaviour [`55c0e5c`](https://github.com/leandrowd/react-responsive-carousel/commit/55c0e5c29924f78b702b714a9c0ec116d35526e4)

## [v3.0.19](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.18...v3.0.19) - 2016-09-24

### Merged

-   Updating react-easy-swipe [`#61`](https://github.com/leandrowd/react-responsive-carousel/pull/61)

### Commits

-   Adding support to auto play [`b40643d`](https://github.com/leandrowd/react-responsive-carousel/commit/b40643d883aa4785fd4cbe31d646e6d824c29ff8)

## [v3.0.18](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.17...v3.0.18) - 2016-09-16

### Merged

-   Moar tests [`#58`](https://github.com/leandrowd/react-responsive-carousel/pull/58)
-   Feature/infinite looping [`#57`](https://github.com/leandrowd/react-responsive-carousel/pull/57)

### Commits

-   Adding more tests for Carousel [`087a6d6`](https://github.com/leandrowd/react-responsive-carousel/commit/087a6d6b99d4bf4271492753d50a9f7a8141f58d)

## [v3.0.17](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.16...v3.0.17) - 2016-09-14

### Merged

-   Replacing the deprecated package reactify with babelify [`#56`](https://github.com/leandrowd/react-responsive-carousel/pull/56)

### Commits

-   Deploying storybook demos [`5d8e841`](https://github.com/leandrowd/react-responsive-carousel/commit/5d8e84173761bcfe2fc74f45d0c4a71bc8a1d5f8)

## [v3.0.16](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.15...v3.0.16) - 2016-09-10

### Merged

-   Storybook and many adjusts resulting from tests inside it. [`#54`](https://github.com/leandrowd/react-responsive-carousel/pull/54)

### Commits

-   Adding presentation mode [`38139e7`](https://github.com/leandrowd/react-responsive-carousel/commit/38139e7a9906680cc4de04aa5d0f2d22aae595e0)

## [v3.0.15](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.14...v3.0.15) - 2016-09-07

### Commits

-   Updating package task to include the fonts [`f10a739`](https://github.com/leandrowd/react-responsive-carousel/commit/f10a739e081e83275b362a1e60f5e729a8403742)
-   Updating docs with example [`6feaeb4`](https://github.com/leandrowd/react-responsive-carousel/commit/6feaeb40b520e830f04b060262f509ac8feee53e)
-   Removing release branch from publish step [`c10616d`](https://github.com/leandrowd/react-responsive-carousel/commit/c10616de82c8f7cef760f325c39737e11994010b)

## [v3.0.14](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.13...v3.0.14) - 2016-09-07

### Merged

-   Update gulp dependencies [`#50`](https://github.com/leandrowd/react-responsive-carousel/pull/50)

### Commits

-   Fixing gh-pages task [`5da8b4d`](https://github.com/leandrowd/react-responsive-carousel/commit/5da8b4ddbfab6dbf079350b9ad6aaf07001d871d)

## [v3.0.13](https://github.com/leandrowd/react-responsive-carousel/compare/v1.0.2...v3.0.13) - 2016-08-27

### Merged

-   Improving dev workflow [`#49`](https://github.com/leandrowd/react-responsive-carousel/pull/49)
-   Update dependencies [`#48`](https://github.com/leandrowd/react-responsive-carousel/pull/48)
-   Running tests with jest-cli instead of gulp-jest [`#47`](https://github.com/leandrowd/react-responsive-carousel/pull/47)
-   Add type to carousel buttons [`#46`](https://github.com/leandrowd/react-responsive-carousel/pull/46)
-   Update gulp-sass version. [`#40`](https://github.com/leandrowd/react-responsive-carousel/pull/40)
-   Update Carousel.js [`#37`](https://github.com/leandrowd/react-responsive-carousel/pull/37)

### Commits

-   Updating dependencies and tasks: [`7fd718c`](https://github.com/leandrowd/react-responsive-carousel/commit/7fd718cd73624aac21fc6ea796761530f2cebd28)

## [3.0.9](https://github.com/leandrowd/react-responsive-carousel/compare/3.0.7...3.0.9) - 2016-01-19

### Commits

-   Fixing vertical carousel size [`4a90da2`](https://github.com/leandrowd/react-responsive-carousel/commit/4a90da2a8c75b7109e8672ef7ab0cbf96da41a68)
-   Fixing propTypes typo (was propsTypes) [`dad89b6`](https://github.com/leandrowd/react-responsive-carousel/commit/dad89b6f539648c8611c4c20ac384febc89eed96)
-   Publishing to npm [`edc64f2`](https://github.com/leandrowd/react-responsive-carousel/commit/edc64f2c6624101c4e8317cf589837c361b339e9)

## [3.0.7](https://github.com/leandrowd/react-responsive-carousel/compare/v1.0.1...3.0.7) - 2016-01-15

### Commits

-   Updating readme [`c5c72b9`](https://github.com/leandrowd/react-responsive-carousel/commit/c5c72b981713c68f8b13e140e16b50dc1af47b8d)
-   Server rendering in strict mode can't find window [`2902cb1`](https://github.com/leandrowd/react-responsive-carousel/commit/2902cb1f99a0eeef106d5ae5ab1c1fb18619e477)
-   Updating npm package [`621a207`](https://github.com/leandrowd/react-responsive-carousel/commit/621a207a29721d19fe9e760cf8238e662d3aae4a)

## [3.0.4](https://github.com/leandrowd/react-responsive-carousel/compare/3.0.2...3.0.4) - 2016-01-07

### Commits

-   Adding CNAME [`26eb839`](https://github.com/leandrowd/react-responsive-carousel/commit/26eb8394eb09a82db61c7ddb9830beab651e1b66)
-   Bumping versions [`51caa42`](https://github.com/leandrowd/react-responsive-carousel/commit/51caa4252adc2f232c74d06c48bf71eaeb81bd75)

## [3.0.2](https://github.com/leandrowd/react-responsive-carousel/compare/v1.0.0...3.0.2) - 2016-01-07

### Commits

-   Updating npm package docs [`76aa2e7`](https://github.com/leandrowd/react-responsive-carousel/commit/76aa2e72b5b4dee56f75da3fda02d58bb0eec9c5)
-   Updating dist files [`b1c2fd8`](https://github.com/leandrowd/react-responsive-carousel/commit/b1c2fd80e4d2a65eab4bfac44282df3ad26633fe)
-   Releasing new npm package [`6637e47`](https://github.com/leandrowd/react-responsive-carousel/commit/6637e47eb0dfde970b22e1703ae37b53d973e9ec)

## [2.0.2](https://github.com/leandrowd/react-responsive-carousel/compare/2.0.1...2.0.2) - 2015-11-26

### Commits

-   Issue #19 - fixing undef position [`4e7602e`](https://github.com/leandrowd/react-responsive-carousel/commit/4e7602e65ce742544c0979889dab6a1d395dc008)
-   issue #17 - Calling onChange when selecting through the controls [`10470fe`](https://github.com/leandrowd/react-responsive-carousel/commit/10470fe533e4cabf908acf95d5ccf9bc585b486c)

## [2.0.1](https://github.com/leandrowd/react-responsive-carousel/compare/2.0.0...2.0.1) - 2015-11-21

### Commits

-   #17 - Calling onChange when selecting through the controls [`0d2368f`](https://github.com/leandrowd/react-responsive-carousel/commit/0d2368fb3b1579a457225121a2fb7c11aefb46cf)

## [2.0.0](https://github.com/leandrowd/react-responsive-carousel/compare/0.1.6...2.0.0) - 2015-11-21

### Commits

-   Updating react to 0.14 and fixing all the warnings [`87fe13d`](https://github.com/leandrowd/react-responsive-carousel/commit/87fe13db8f3e71b073dbc0269165d06cbf0f2d08)
-   Fixing dependencies and preparing package for distribution [`2377fde`](https://github.com/leandrowd/react-responsive-carousel/commit/2377fded11f9a301f03f8884a7374f3132b18a0b)
-   Updating docs [`68ab271`](https://github.com/leandrowd/react-responsive-carousel/commit/68ab27107d8bec25b1745fc4f04588b66fa96235)

## [v1.0.2](https://github.com/leandrowd/react-responsive-carousel/compare/3.0.9...v1.0.2) - 2016-03-17

### Merged

-   Specify version of node to run app [`#31`](https://github.com/leandrowd/react-responsive-carousel/pull/31)

### Commits

-   Publishig to npm [`2d40b85`](https://github.com/leandrowd/react-responsive-carousel/commit/2d40b85593f0cb2d4397b973ae842fc15cd25608)

## [v1.0.1](https://github.com/leandrowd/react-responsive-carousel/compare/3.0.4...v1.0.1) - 2016-01-13

### Commits

-   Removing unneded file [`9d7f7cb`](https://github.com/leandrowd/react-responsive-carousel/commit/9d7f7cbf93abbd3cee691380a6365e684c45c523)
-   Adding missing dependency [`bb2e2fb`](https://github.com/leandrowd/react-responsive-carousel/commit/bb2e2fbaa5f794855c24e55671e7cbcac24da142)
-   1.0.1 [`4d9b33e`](https://github.com/leandrowd/react-responsive-carousel/commit/4d9b33e1f02949f2077087625fbebe33fd74189a)

## [v1.0.0](https://github.com/leandrowd/react-responsive-carousel/compare/2.0.2...v1.0.0) - 2016-01-07

### Merged

-   Carousel revamp [`#25`](https://github.com/leandrowd/react-responsive-carousel/pull/25)
-   Update README.md [`#21`](https://github.com/leandrowd/react-responsive-carousel/pull/21)

### Commits

-   Replacing refs [`cfa023e`](https://github.com/leandrowd/react-responsive-carousel/commit/cfa023eea5038d38b466ab9db525d31a01c0e736)

## [0.1.6](https://github.com/leandrowd/react-responsive-carousel/compare/0.1.4...0.1.6) - 2015-08-08

### Merged

-   Delaying the .selected class/state till the image is loaded so the border won't appear without anything inside. [`#15`](https://github.com/leandrowd/react-responsive-carousel/pull/15)
-   fix default selected class [`#1`](https://github.com/leandrowd/react-responsive-carousel/pull/1)

### Commits

-   update demo page with gulp [`fb450aa`](https://github.com/leandrowd/react-responsive-carousel/commit/fb450aaa4626615f4cb03bbc488a4a591f408360)

## [0.1.4](https://github.com/leandrowd/react-responsive-carousel/compare/0.1.1...0.1.4) - 2015-06-30

### Merged

-   carousel on mobile: disable swiping on first and last image [`#11`](https://github.com/leandrowd/react-responsive-carousel/pull/11)
-   fix dependencies [`#5`](https://github.com/leandrowd/react-responsive-carousel/pull/5)

### Commits

-   fix carousel on mobile: disable swiping on first and last image [`47d0451`](https://github.com/leandrowd/react-responsive-carousel/commit/47d04517e74db377bcc7e4250a0093e202ca85d4)

## [0.1.1](https://github.com/leandrowd/react-responsive-carousel/compare/0.1.0...0.1.1) - 2015-05-17

### Commits

-   Updating to react 0.13.3 [`5726925`](https://github.com/leandrowd/react-responsive-carousel/commit/5726925e8f9157be06a53f53285208e8a6703b31)
-   Generating version 0.1.1 for NPN [`72fc98a`](https://github.com/leandrowd/react-responsive-carousel/commit/72fc98aa6af06ee98907029e45a9016e1f04a026)

## [0.1.0](https://github.com/leandrowd/react-responsive-carousel/compare/0.0.11...0.1.0) - 2015-03-11

### Commits

-   New version without touch lib [`5d7f735`](https://github.com/leandrowd/react-responsive-carousel/commit/5d7f7359c4b98773bbf8c544d6c3d2cd19b0e4f9)
-   Clean up [`4914ea8`](https://github.com/leandrowd/react-responsive-carousel/commit/4914ea8f9f0d1d11d2ba212c930cb5f7f63b8713)
-   Adding styles to the package [`1a487cd`](https://github.com/leandrowd/react-responsive-carousel/commit/1a487cd23a37dc483dab5be588f9f08c9761f376)

## [0.0.11](https://github.com/leandrowd/react-responsive-carousel/compare/0.0.9...0.0.11) - 2015-02-10

### Commits

-   Fixing tests, adding more infos to README.md and removing unnecessary files [`1363c42`](https://github.com/leandrowd/react-responsive-carousel/commit/1363c429ecfd13730318925a38507fbb52c4a448)
-   Fixing require rule on README.md and publishing [`d2c44b2`](https://github.com/leandrowd/react-responsive-carousel/commit/d2c44b2d63032a4daa69d3addec11e7585d23d08)
-   Adding README.md to npm [`966d949`](https://github.com/leandrowd/react-responsive-carousel/commit/966d9492b28e3211705637b2a0321b9d9b8fab41)

## 0.0.9 - 2015-02-09

### Commits

-   First commit [`272de1d`](https://github.com/leandrowd/react-responsive-carousel/commit/272de1d4ea25d4c64cf9a11f3d49a9ab0daa90cf)
-   Removing swipe component and add behaviour through another lib [`8fe3efd`](https://github.com/leandrowd/react-responsive-carousel/commit/8fe3efdcd811cf464efab7420ffe85f41f1ef3c3)
-   Adding better transitions [`48ebe3c`](https://github.com/leandrowd/react-responsive-carousel/commit/48ebe3c72cef1cdcff7b275257fc3c54afb19e21)
