import React from 'react';
import type { FocusAndScrollRef } from '../../client/components/reducer';
import type { FlightRouterState, FlightData } from '../../server/app-render';
export declare type ChildSegmentMap = Map<string, CacheNode>;
/**
 * Cache node used in app-router / layout-router.
 */
export declare type CacheNode = {
    /**
     * In-flight request for this node.
     */
    data: ReturnType<typeof import('../../client/components/app-router.client').fetchServerResponse> | null;
    /**
     * React Component for this node.
     */
    subTreeData: React.ReactNode | null;
    /**
     * Child parallel routes.
     */
    parallelRoutes: Map<string, ChildSegmentMap>;
};
export declare type AppRouterInstance = {
    /**
     * Reload the current page. Fetches new data from the server.
     */
    reload(): void;
    /**
     * Hard navigate to the provided href. Fetches new data from the server.
     * Pushes a new history entry.
     */
    push(href: string): void;
    /**
     * Soft navigate to the provided href. Does not fetch data from the server if it was already fetched.
     * Pushes a new history entry.
     */
    softPush(href: string): void;
    /**
     * Hard navigate to the provided href. Does not fetch data from the server if it was already fetched.
     * Replaces the current history entry.
     */
    replace(href: string): void;
    /**
     * Soft navigate to the provided href. Does not fetch data from the server if it was already fetched.
     * Replaces the current history entry.
     */
    softReplace(href: string): void;
    /**
     * Soft prefetch the provided href. Does not fetch data from the server if it was already fetched.
     */
    prefetch(href: string): Promise<void>;
};
export declare const AppRouterContext: React.Context<AppRouterInstance>;
export declare const LayoutRouterContext: React.Context<{
    childNodes: CacheNode['parallelRoutes'];
    tree: FlightRouterState;
    url: string;
    stylesheets?: string[] | undefined;
}>;
export declare const GlobalLayoutRouterContext: React.Context<{
    tree: FlightRouterState;
    changeByServerResponse: (previousTree: FlightRouterState, flightData: FlightData) => void;
    focusAndScrollRef: FocusAndScrollRef;
}>;
