import type { AssetBinding } from '../loaders/get-module-build-info';
import { webpack5 } from 'next/dist/compiled/webpack/webpack';
export interface EdgeFunctionDefinition {
    env: string[];
    files: string[];
    name: string;
    page: string;
    regexp: string;
    wasm?: AssetBinding[];
    assets?: AssetBinding[];
}
export interface MiddlewareManifest {
    version: 1;
    sortedMiddleware: string[];
    middleware: {
        [page: string]: EdgeFunctionDefinition;
    };
    functions: {
        [page: string]: EdgeFunctionDefinition;
    };
}
export default class MiddlewarePlugin {
    dev: boolean;
    constructor({ dev }: {
        dev: boolean;
    });
    apply(compiler: webpack5.Compiler): void;
}
export declare function handleWebpackExtenalForEdgeRuntime({ request, context, contextInfo, getResolve, }: {
    request: string;
    context: string;
    contextInfo: any;
    getResolve: () => any;
}): Promise<string | undefined>;
