import React from 'react';
import { ExtraData } from './types';
import { Client } from '@formspree/core';
import { SubmissionResponse, SubmissionData, FormError } from '@formspree/core/forms';
declare type FormEvent = React.FormEvent<HTMLFormElement>;
declare type SubmitHandler = (submissionData: FormEvent | SubmissionData) => Promise<SubmissionResponse>;
declare type ResetFunction = () => void;
export declare function useForm(formKey: string, args?: {
    client?: Client;
    data?: ExtraData;
    endpoint?: string;
    debug?: boolean;
}): [{
    submitting: boolean;
    succeeded: boolean;
    errors: FormError[];
}, SubmitHandler, ResetFunction];
export {};
