import * as Forms from '@formspree/core/forms';
export { isFieldError } from '@formspree/core/forms';
export declare type FormError = Forms.FormError;
export declare type FieldError = Forms.FieldError;
/**
 * ExtraData values can be strings or functions that return a string, or a
 * promise that resolves to a string. Errors should be handled internally.
 * Functions can return undefined to skip this ExtraData value.
 */
export declare type ExtraDataValue = string | (() => string) | (() => Promise<string>) | (() => undefined) | (() => Promise<undefined>);
export declare type ExtraData = {
    [key: string]: ExtraDataValue;
};
export declare type ErrorPayload = Forms.FormError;
