declare const _exports: {
    "name": string;
    "version": string;
    "description": string;
    "bugs": {
        "url": string;
    };
    "repository": {
        "type": string;
        "url": string;
    };
    "license": string;
    "contributors": string[];
    "files": string[];
    "main": string;
    "module": string;
    "types": string;
    "scripts": {
        "build": string;
        "build:js": string;
        "build:types": string;
        "format": string;
        "prepare": string;
        "release": string;
        "test": string;
        "type-check": string;
        "type-check:watch": string;
    };
    "husky": {
        "hooks": {
            "pre-commit": string;
        };
    };
    "lint-staged": {
        "*.{js,ts,tsx,css,json,md}": string[];
        "package.json": string[];
    };
    "dependencies": {
        "@formspree/core": string;
    };
    "devDependencies": {
        "@babel/core": string;
        "@babel/plugin-transform-runtime": string;
        "@babel/preset-env": string;
        "@babel/preset-react": string;
        "@babel/preset-typescript": string;
        "@babel/runtime": string;
        "@rollup/plugin-babel": string;
        "@rollup/plugin-commonjs": string;
        "@rollup/plugin-json": string;
        "@rollup/plugin-node-resolve": string;
        "@types/jest": string;
        "@types/react": string;
        "@types/react-dom": string;
        "babel-jest": string;
        "husky": string;
        "jest": string;
        "lint-staged": string;
        "np": string;
        "prettier": string;
        "react": string;
        "react-dom": string;
        "react-test-renderer": string;
        "rollup": string;
        "sort-package-json": string;
        "tslib": string;
        "typescript": string;
    };
    "peerDependencies": {
        "react": string;
    };
    "publishConfig": {
        "access": string;
    };
    "np": {
        "yarn": boolean;
    };
};
export = _exports;
