/// <reference types="promise-polyfill" />
import { SubmissionData, SubmissionOptions, SubmissionResponse } from './forms';
export interface Config {
    project?: string;
}
export declare class Client {
    project: string | undefined;
    private session;
    constructor(config?: Config);
    /**
     * Starts a browser session.
     */
    startBrowserSession(): void;
    /**
     * Teardown the client session.
     */
    teardown(): void;
    /**
     * Submit a form.
     *
     * @param formKey - The form key.
     * @param data - An object or FormData instance containing submission data.
     * @param args - An object of form submission data.
     */
    submitForm(formKey: string, data: SubmissionData, opts?: SubmissionOptions): Promise<SubmissionResponse>;
}
/**
 * Constructs the client object.
 */
export declare const createClient: (config?: Config | undefined) => Client;
/**
 * Fetches the global default client.
 */
export declare const getDefaultClient: () => Client;
