export declare type SubmissionData = FormData | object;
export interface SubmissionOptions {
    endpoint?: string;
    clientName?: string;
    fetchImpl?: typeof fetch;
}
declare enum FormErrorCodeEnum {
    INACTIVE = "INACTIVE",
    BLOCKED = "BLOCKED",
    EMPTY = "EMPTY",
    PROJECT_NOT_FOUND = "PROJECT_NOT_FOUND",
    FORM_NOT_FOUND = "FORM_NOT_FOUND",
    NO_FILE_UPLOADS = "NO_FILE_UPLOADS",
    TOO_MANY_FILES = "TOO_MANY_FILES",
    FILES_TOO_BIG = "FILES_TOO_BIG"
}
declare enum FieldErrorCodeEnum {
    REQUIRED_FIELD_MISSING = "REQUIRED_FIELD_MISSING",
    REQUIRED_FIELD_EMPTY = "REQUIRED_FIELD_EMPTY",
    TYPE_EMAIL = "TYPE_EMAIL",
    TYPE_NUMERIC = "TYPE_NUMERIC",
    TYPE_TEXT = "TYPE_TEXT"
}
export declare type FormErrorCode = keyof typeof FormErrorCodeEnum;
export declare type FieldErrorCode = keyof typeof FieldErrorCodeEnum;
export interface FormError {
    field?: string;
    code?: FormErrorCode | FieldErrorCode;
    message: string;
}
export interface FieldError extends FormError {
    field: string;
    code: FieldErrorCode;
}
export declare function isFieldError(error: FormError): error is FieldError;
declare type KnownError<T> = T extends {
    code: FormErrorCode;
} | {
    code: FieldErrorCode;
} ? T : never;
export declare function isKnownError(error: FormError): error is KnownError<FormError>;
export interface SuccessBody {
    id: string;
    data: object;
}
export interface ErrorBody {
    errors: FormError[];
}
export declare type SubmissionBody = SuccessBody | ErrorBody;
export declare function hasErrors(body: SubmissionBody): body is ErrorBody;
export interface SubmissionResponse {
    body: SubmissionBody;
    response: Response;
}
export {};
